/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractDataTable;
import com.mckoi.database.BlindSearch;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.Database;
import com.mckoi.database.InsertSearch;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.util.IntegerVector;

public abstract class DefaultDataTable
extends AbstractDataTable {
    private Database database;
    protected int row_count;
    private SelectableScheme[] column_scheme;

    DefaultDataTable(Database database) {
        this.database = database;
        this.row_count = 0;
    }

    public Database getDatabase() {
        return this.database;
    }

    protected SelectableScheme getRootColumnScheme(int column) {
        return this.column_scheme[column];
    }

    protected void clearColumnScheme(int column) {
        this.column_scheme[column] = null;
    }

    protected void blankSelectableSchemes() {
        this.blankSelectableSchemes(0);
    }

    protected void blankSelectableSchemes(int type) {
        this.column_scheme = new SelectableScheme[this.getColumnCount()];
        for (int i = 0; i < this.column_scheme.length; ++i) {
            if (type == 0) {
                this.column_scheme[i] = new InsertSearch(this, i);
                continue;
            }
            if (type != 1) continue;
            this.column_scheme[i] = new BlindSearch(this, i);
        }
    }

    public int getColumnCount() {
        return this.getDataTableDef().columnCount();
    }

    public int getRowCount() {
        return this.row_count;
    }

    public Variable getResolvedVariable(int column) {
        String col_name = this.getDataTableDef().columnAt(column).getName();
        return new Variable(this.getTableName(), col_name);
    }

    public int findFieldName(Variable v) {
        TableName table_name = v.getTableName();
        DataTableDef table_def = this.getDataTableDef();
        if (table_name != null && table_name.equals(this.getTableName())) {
            String col_name = v.getName();
            int size = this.getColumnCount();
            for (int i = 0; i < size; ++i) {
                DataTableColumnDef col = table_def.columnAt(i);
                if (!col.getName().equals(col_name)) continue;
                return i;
            }
        }
        return -1;
    }

    SelectableScheme getSelectableSchemeFor(int column, int original_column, Table table) {
        SelectableScheme scheme = this.getRootColumnScheme(column);
        if (table == this) {
            return scheme;
        }
        return scheme.getSubsetScheme(table, original_column);
    }

    void setToRowTableDomain(int column, IntegerVector row_set, TableDataSource ancestor) {
        if (ancestor != this) {
            throw new RuntimeException("Method routed to incorrect table ancestor.");
        }
    }

    RawTableInformation resolveToRawTable(RawTableInformation info) {
        System.err.println("Efficiency Warning in DataTable.resolveToRawTable.");
        IntegerVector row_set = new IntegerVector();
        RowEnumeration e = this.rowEnumeration();
        while (e.hasMoreRows()) {
            row_set.addInt(e.nextRowIndex());
        }
        info.add(this, row_set);
        return info;
    }

    void addCellToColumnSchemes(int row_number, int column_number) {
        boolean indexable_type = this.getDataTableDef().columnAt(column_number).isIndexableType();
        if (indexable_type) {
            SelectableScheme ss = this.getRootColumnScheme(column_number);
            ss.insert(row_number);
        }
    }

    void addRowToColumnSchemes(int row_number) {
        int col_count = this.getColumnCount();
        DataTableDef table_def = this.getDataTableDef();
        for (int i = 0; i < col_count; ++i) {
            if (!table_def.columnAt(i).isIndexableType()) continue;
            SelectableScheme ss = this.getRootColumnScheme(i);
            ss.insert(row_number);
        }
    }

    void removeRowToColumnSchemes(int row_number) {
        int col_count = this.getColumnCount();
        DataTableDef table_def = this.getDataTableDef();
        for (int i = 0; i < col_count; ++i) {
            if (!table_def.columnAt(i).isIndexableType()) continue;
            SelectableScheme ss = this.getRootColumnScheme(i);
            ss.remove(row_number);
        }
    }
}

